/*
 * q_srv02_pos.c
 *
 * Real-Time Workshop code generation for Simulink model "q_srv02_pos.mdl".
 *
 * Model version              : 1.173
 * Real-Time Workshop version : 7.5  (R2010a)  25-Jan-2010
 * C source code generated on : Mon Dec 05 14:43:18 2011
 *
 * Target selection: quarc_windows.tlc
 * Note: GRT includes extra infrastructure and instrumentation for prototyping
 * Embedded hardware selection: 32-bit Generic
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "q_srv02_pos.h"
#include "q_srv02_pos_private.h"
#include <stdio.h>
#include "q_srv02_pos_dt.h"

/* Block signals (auto storage) */
BlockIO_q_srv02_pos q_srv02_pos_B;

/* Continuous states */
ContinuousStates_q_srv02_pos q_srv02_pos_X;

/* Block states (auto storage) */
D_Work_q_srv02_pos q_srv02_pos_DWork;

/* Real-time model */
RT_MODEL_q_srv02_pos q_srv02_pos_M_;
RT_MODEL_q_srv02_pos *q_srv02_pos_M = &q_srv02_pos_M_;

/*
 * This function updates continuous states using the ODE1 fixed-step
 * solver algorithm
 */
static void rt_ertODEUpdateContinuousStates(RTWSolverInfo *si )
{
  time_T tnew = rtsiGetSolverStopTime(si);
  time_T h = rtsiGetStepSize(si);
  real_T *x = rtsiGetContStates(si);
  ODE1_IntgData *id = (ODE1_IntgData *)rtsiGetSolverData(si);
  real_T *f0 = id->f[0];
  int_T i;
  int_T nXc = 5;
  rtsiSetSimTimeStep(si,MINOR_TIME_STEP);
  rtsiSetdX(si, f0);
  q_srv02_pos_derivatives();
  rtsiSetT(si, tnew);
  for (i = 0; i < nXc; i++) {
    *x += h * f0[i];
    x++;
  }

  rtsiSetSimTimeStep(si,MAJOR_TIME_STEP);
}

/* Model output function */
void q_srv02_pos_output(int_T tid)
{
  real_T temp;
  if (rtmIsMajorTimeStep(q_srv02_pos_M)) {
    /* set solver stop time */
    if (!(q_srv02_pos_M->Timing.clockTick0+1)) {
      rtsiSetSolverStopTime(&q_srv02_pos_M->solverInfo,
                            ((q_srv02_pos_M->Timing.clockTickH0 + 1) *
        q_srv02_pos_M->Timing.stepSize0 * 4294967296.0));
    } else {
      rtsiSetSolverStopTime(&q_srv02_pos_M->solverInfo,
                            ((q_srv02_pos_M->Timing.clockTick0 + 1) *
        q_srv02_pos_M->Timing.stepSize0 + q_srv02_pos_M->Timing.clockTickH0 *
        q_srv02_pos_M->Timing.stepSize0 * 4294967296.0));
    }
  }                                    /* end MajorTimeStep */

  /* Update absolute time of base rate at minor time step */
  if (rtmIsMinorTimeStep(q_srv02_pos_M)) {
    q_srv02_pos_M->Timing.t[0] = rtsiGetT(&q_srv02_pos_M->solverInfo);
  }

  if (rtmIsMajorTimeStep(q_srv02_pos_M)) {
    /* S-Function (hil_read_analog_timebase_block): '<S6>/HIL Read Analog Timebase' */

    /* S-Function Block: q_srv02_pos/SRV02-ET Position/SRV02-ET/HIL Read Analog Timebase (hil_read_analog_timebase_block) */
    {
      t_error result;
      result = hil_task_read_analog(q_srv02_pos_DWork.HILReadAnalogTimebase_Task,
        1, &q_srv02_pos_DWork.HILReadAnalogTimebase_Buffer[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
      }

      q_srv02_pos_B.HILReadAnalogTimebase_o1 =
        q_srv02_pos_DWork.HILReadAnalogTimebase_Buffer[0];
      q_srv02_pos_B.HILReadAnalogTimebase_o2 =
        q_srv02_pos_DWork.HILReadAnalogTimebase_Buffer[1];
    }

    /* S-Function (hil_read_encoder_block): '<S6>/HIL Read Encoder' */

    /* S-Function Block: q_srv02_pos/SRV02-ET Position/SRV02-ET/HIL Read Encoder (hil_read_encoder_block) */
    {
      t_error result = hil_read_encoder(q_srv02_pos_DWork.HILInitialize_Card,
        &q_srv02_pos_P.HILReadEncoder_Channels, 1,
        &q_srv02_pos_DWork.HILReadEncoder_Buffer);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
      } else {
        q_srv02_pos_B.HILReadEncoder = q_srv02_pos_DWork.HILReadEncoder_Buffer;
      }
    }

    /* Gain: '<S6>/Encoder Calibration  (rad//count)' */
    q_srv02_pos_B.EncoderCalibrationradcount =
      q_srv02_pos_P.EncoderCalibrationradcount_Gain *
      q_srv02_pos_B.HILReadEncoder;
  }

  /* TransferFcn: '<S6>/Encoder High-Pass Filter' */
  q_srv02_pos_B.EncoderHighPassFilter = q_srv02_pos_P.EncoderHighPassFilter_C[0]*
    q_srv02_pos_X.EncoderHighPassFilter_CSTATE[0]
    + q_srv02_pos_P.EncoderHighPassFilter_C[1]*
    q_srv02_pos_X.EncoderHighPassFilter_CSTATE[1];
  if (rtmIsMajorTimeStep(q_srv02_pos_M)) {
    /* MultiPortSwitch: '<S6>/Position Source Switch' incorporates:
     *  Constant: '<Root>/Pos Src'
     */
    if ((int32_T)q_srv02_pos_P.PosSrc_Value == 1) {
      /* Gain: '<S6>/Potentiometer Calibration  (rad//V)' */
      q_srv02_pos_B.PotentiometerCalibrationradV =
        q_srv02_pos_P.PotentiometerCalibrationradV_Ga *
        q_srv02_pos_B.HILReadAnalogTimebase_o1;
      q_srv02_pos_B.PositionSourceSwitch =
        q_srv02_pos_B.PotentiometerCalibrationradV;
    } else {
      q_srv02_pos_B.PositionSourceSwitch =
        q_srv02_pos_B.EncoderCalibrationradcount;
    }

    /* Gain: '<S6>/Tachometer Calibration  (rad//s//V)' */
    q_srv02_pos_B.TachometerCalibrationradsV =
      q_srv02_pos_P.TachometerCalibrationradsV_Gain *
      q_srv02_pos_B.HILReadAnalogTimebase_o2;
  }

  /* MultiPortSwitch: '<S6>/Velocity Source Switch' incorporates:
   *  Constant: '<S4>/Spd Src'
   */
  if ((int32_T)q_srv02_pos_P.SpdSrc_Value == 1) {
    q_srv02_pos_B.VelocitySourceSwitch =
      q_srv02_pos_B.TachometerCalibrationradsV;
  } else {
    q_srv02_pos_B.VelocitySourceSwitch = q_srv02_pos_B.EncoderHighPassFilter;
  }

  /* SignalGenerator: '<S3>/Square Wave' */
  temp = q_srv02_pos_P.SquareWave_Frequency * q_srv02_pos_M->Timing.t[0];
  if (temp - floor(temp) >= 0.5) {
    q_srv02_pos_B.SquareWave = q_srv02_pos_P.SquareWave_Amplitude;
  } else {
    q_srv02_pos_B.SquareWave = -q_srv02_pos_P.SquareWave_Amplitude;
  }

  /* Clock: '<S5>/Clock' */
  q_srv02_pos_B.Clock = q_srv02_pos_M->Timing.t[0];

  /* SignalGenerator: '<S3>/Sine Wave' */
  temp = 6.2831853071795862E+000 * q_srv02_pos_M->Timing.t[0];
  q_srv02_pos_B.SineWave = sin(q_srv02_pos_P.SineWave_Frequency * temp) *
    q_srv02_pos_P.SineWave_Amplitude;

  /* MultiPortSwitch: '<S3>/Multiport Switch' incorporates:
   *  Constant: '<S3>/Constant'
   */
  switch ((int32_T)q_srv02_pos_P.Constant_Value) {
   case 1:
    q_srv02_pos_B.MultiportSwitch = q_srv02_pos_B.SquareWave;
    break;

   case 2:
    /* Math: '<S5>/t' incorporates:
     *  Constant: '<S5>/Period (s)'
     */
    q_srv02_pos_B.t = rt_mod_snf(q_srv02_pos_B.Clock,
      q_srv02_pos_P.Periods_Value);

    /* RelationalOperator: '<S5>/t >= 1//(2*f)?' incorporates:
     *  Constant: '<S5>/Half Period (s)'
     */
    q_srv02_pos_B.t12f_b = (q_srv02_pos_B.t >= q_srv02_pos_P.HalfPeriods_Value);

    /* MultiPortSwitch: '<S5>/Multiport Switch' */
    if ((int32_T)q_srv02_pos_B.t12f_b == 0) {
      /* Gain: '<S5>/R0' */
      q_srv02_pos_B.R0 = q_srv02_pos_P.R0_Gain * q_srv02_pos_B.t;

      /* Sum: '<S5>/Sum' incorporates:
       *  Constant: '<S5>/Amplitude'
       */
      q_srv02_pos_B.Sum = q_srv02_pos_B.R0 - q_srv02_pos_P.Amplitude_Value;
      q_srv02_pos_B.MultiportSwitch_p = q_srv02_pos_B.Sum;
    } else {
      /* Sum: '<S5>/t-1//(2*f)' incorporates:
       *  Constant: '<S5>/Half Period (s)'
       */
      q_srv02_pos_B.t12f = q_srv02_pos_B.t - q_srv02_pos_P.HalfPeriods_Value;

      /* Gain: '<S5>/-R0*(t-1//(2*f))' */
      q_srv02_pos_B.R0t12f = q_srv02_pos_P.R0t12f_Gain * q_srv02_pos_B.t12f;

      /* Sum: '<S5>/Sum1' incorporates:
       *  Constant: '<S5>/Amplitude'
       */
      q_srv02_pos_B.Sum1 = q_srv02_pos_P.Amplitude_Value + q_srv02_pos_B.R0t12f;
      q_srv02_pos_B.MultiportSwitch_p = q_srv02_pos_B.Sum1;
    }

    q_srv02_pos_B.MultiportSwitch = q_srv02_pos_B.MultiportSwitch_p;
    break;

   default:
    q_srv02_pos_B.MultiportSwitch = q_srv02_pos_B.SineWave;
    break;
  }

  /* Gain: '<Root>/Amplitude (rad)' */
  q_srv02_pos_B.Amplituderad = q_srv02_pos_P.Amplituderad_Gain *
    q_srv02_pos_B.MultiportSwitch;

  /* Sum: '<S1>/Position Error (rad)' */
  q_srv02_pos_B.PositionErrorrad = q_srv02_pos_B.Amplituderad -
    q_srv02_pos_B.PositionSourceSwitch;

  /* Gain: '<S1>/Proportional Gain  (V//rad)' */
  q_srv02_pos_B.ProportionalGainVrad = q_srv02_pos_P.ProportionalGainVrad_Gain *
    q_srv02_pos_B.PositionErrorrad;

  /* Integrator: '<S1>/Integrator'
   * About '<S1>/Integrator':
   *  Limited Integrator
   */
  if (q_srv02_pos_X.Integrator_CSTATE >= q_srv02_pos_P.Integrator_UpperSat ) {
    q_srv02_pos_X.Integrator_CSTATE = q_srv02_pos_P.Integrator_UpperSat;
  } else if (q_srv02_pos_X.Integrator_CSTATE <=
             q_srv02_pos_P.Integrator_LowerSat ) {
    q_srv02_pos_X.Integrator_CSTATE = q_srv02_pos_P.Integrator_LowerSat;
  }

  q_srv02_pos_B.Integrator = q_srv02_pos_X.Integrator_CSTATE;

  /* TransferFcn: '<S1>/High-pass filter' */
  q_srv02_pos_B.Highpassfilter = q_srv02_pos_P.Highpassfilter_C[0]*
    q_srv02_pos_X.Highpassfilter_CSTATE[0]
    + q_srv02_pos_P.Highpassfilter_C[1]*q_srv02_pos_X.Highpassfilter_CSTATE[1];

  /* Gain: '<S1>/Velocity Gain  (V.s//rad)' */
  q_srv02_pos_B.VelocityGainVsrad = q_srv02_pos_P.VelocityGainVsrad_Gain *
    q_srv02_pos_B.Highpassfilter;

  /* Sum: '<S1>/Control  Output' */
  q_srv02_pos_B.ControlOutput = (q_srv02_pos_B.ProportionalGainVrad +
    q_srv02_pos_B.Integrator) + q_srv02_pos_B.VelocityGainVsrad;

  /* Gain: '<S7>/Direction Convention: (Right-Hand) system' */
  q_srv02_pos_B.DirectionConventionRightHandsys =
    q_srv02_pos_P.DirectionConventionRightHandsys * q_srv02_pos_B.ControlOutput;

  /* Saturate: '<S7>/Amplifier  Saturation (V)' */
  temp = q_srv02_pos_B.DirectionConventionRightHandsys;
  q_srv02_pos_B.AmplifierSaturationV = rt_SATURATE(temp,
    q_srv02_pos_P.AmplifierSaturationV_LowerSat,
    q_srv02_pos_P.AmplifierSaturationV_UpperSat);

  /* Gain: '<S7>/Inverse Amplifier  Gain (V//V)' */
  q_srv02_pos_B.InverseAmplifierGainVV =
    q_srv02_pos_P.InverseAmplifierGainVV_Gain *
    q_srv02_pos_B.AmplifierSaturationV;

  /* Saturate: '<S7>/DACB Saturation (V)' */
  temp = q_srv02_pos_B.InverseAmplifierGainVV;
  q_srv02_pos_B.DACBSaturationV = rt_SATURATE(temp,
    q_srv02_pos_P.DACBSaturationV_LowerSat,
    q_srv02_pos_P.DACBSaturationV_UpperSat);
  if (rtmIsMajorTimeStep(q_srv02_pos_M)) {
    /* S-Function (hil_write_analog_block): '<S6>/HIL Write Analog' */

    /* S-Function Block: q_srv02_pos/SRV02-ET Position/SRV02-ET/HIL Write Analog (hil_write_analog_block) */
    {
      t_error result;
      result = hil_write_analog(q_srv02_pos_DWork.HILInitialize_Card,
        &q_srv02_pos_P.HILWriteAnalog_Channels, 1,
        &q_srv02_pos_B.DACBSaturationV);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
      }
    }
  }

  /* Gain: '<S7>/Amplifier  Gain (V//V)' */
  q_srv02_pos_B.AmplifierGainVV = q_srv02_pos_P.AmplifierGainVV_Gain *
    q_srv02_pos_B.DACBSaturationV;
  if (rtmIsMajorTimeStep(q_srv02_pos_M)) {
    /* Gain: '<S1>/-theta_l (deg)' */
    q_srv02_pos_B.theta_ldeg = q_srv02_pos_P.theta_ldeg_Gain *
      q_srv02_pos_B.PositionSourceSwitch;
  }

  /* Gain: '<S1>/Integral Gain  (V//rad//s)' */
  q_srv02_pos_B.IntegralGainVrads = q_srv02_pos_P.IntegralGainVrads_Gain *
    q_srv02_pos_B.PositionErrorrad;

  /* tid is required for a uniform function interface.
   * Argument tid is not used in the function. */
  UNUSED_PARAMETER(tid);
}

/* Model update function */
void q_srv02_pos_update(int_T tid)
{
  if (rtmIsMajorTimeStep(q_srv02_pos_M)) {
    rt_ertODEUpdateContinuousStates(&q_srv02_pos_M->solverInfo);
  }

  /* Update absolute time for base rate */
  /* The "clockTick0" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick0"
   * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
   * overflow during the application lifespan selected.
   * Timer of this task consists of two 32 bit unsigned integers.
   * The two integers represent the low bits Timing.clockTick0 and the high bits
   * Timing.clockTickH0. When the low bit overflows to 0, the high bits increment.
   */
  if (!(++q_srv02_pos_M->Timing.clockTick0)) {
    ++q_srv02_pos_M->Timing.clockTickH0;
  }

  q_srv02_pos_M->Timing.t[0] = rtsiGetSolverStopTime(&q_srv02_pos_M->solverInfo);
  if (rtmIsMajorTimeStep(q_srv02_pos_M)) {
    /* Update absolute timer for sample time: [0.002s, 0.0s] */
    /* The "clockTick1" counts the number of times the code of this task has
     * been executed. The absolute time is the multiplication of "clockTick1"
     * and "Timing.stepSize1". Size of "clockTick1" ensures timer will not
     * overflow during the application lifespan selected.
     * Timer of this task consists of two 32 bit unsigned integers.
     * The two integers represent the low bits Timing.clockTick1 and the high bits
     * Timing.clockTickH1. When the low bit overflows to 0, the high bits increment.
     */
    if (!(++q_srv02_pos_M->Timing.clockTick1)) {
      ++q_srv02_pos_M->Timing.clockTickH1;
    }

    q_srv02_pos_M->Timing.t[1] = q_srv02_pos_M->Timing.clockTick1 *
      q_srv02_pos_M->Timing.stepSize1 + q_srv02_pos_M->Timing.clockTickH1 *
      q_srv02_pos_M->Timing.stepSize1 * 4294967296.0;
  }

  /* tid is required for a uniform function interface.
   * Argument tid is not used in the function. */
  UNUSED_PARAMETER(tid);
}

/* Derivatives for root system: '<Root>' */
void q_srv02_pos_derivatives(void)
{
  /* Derivatives for TransferFcn: '<S6>/Encoder High-Pass Filter' */
  {
    ((StateDerivatives_q_srv02_pos *) q_srv02_pos_M->ModelData.derivs)
      ->EncoderHighPassFilter_CSTATE[0] =
      q_srv02_pos_B.EncoderCalibrationradcount;
    ((StateDerivatives_q_srv02_pos *) q_srv02_pos_M->ModelData.derivs)
      ->EncoderHighPassFilter_CSTATE[0] +=
      (q_srv02_pos_P.EncoderHighPassFilter_A[0])*
      q_srv02_pos_X.EncoderHighPassFilter_CSTATE[0]
      + (q_srv02_pos_P.EncoderHighPassFilter_A[1])*
      q_srv02_pos_X.EncoderHighPassFilter_CSTATE[1];
    ((StateDerivatives_q_srv02_pos *) q_srv02_pos_M->ModelData.derivs)
      ->EncoderHighPassFilter_CSTATE[1]=
      q_srv02_pos_X.EncoderHighPassFilter_CSTATE[0];
  }

  /* Derivatives for Integrator: '<S1>/Integrator' */
  {
    boolean_T lsat;
    boolean_T usat;
    lsat = ( q_srv02_pos_X.Integrator_CSTATE <=
            q_srv02_pos_P.Integrator_LowerSat );
    usat = ( q_srv02_pos_X.Integrator_CSTATE >=
            q_srv02_pos_P.Integrator_UpperSat );
    if ((!lsat && !usat) ||
        (lsat && (q_srv02_pos_B.IntegralGainVrads > 0)) ||
        (usat && (q_srv02_pos_B.IntegralGainVrads < 0)) ) {
      ((StateDerivatives_q_srv02_pos *) q_srv02_pos_M->ModelData.derivs)
        ->Integrator_CSTATE = q_srv02_pos_B.IntegralGainVrads;
    } else {
      /* in saturation */
      ((StateDerivatives_q_srv02_pos *) q_srv02_pos_M->ModelData.derivs)
        ->Integrator_CSTATE = 0.0;
    }
  }

  /* Derivatives for TransferFcn: '<S1>/High-pass filter' */
  {
    ((StateDerivatives_q_srv02_pos *) q_srv02_pos_M->ModelData.derivs)
      ->Highpassfilter_CSTATE[0] = q_srv02_pos_B.theta_ldeg;
    ((StateDerivatives_q_srv02_pos *) q_srv02_pos_M->ModelData.derivs)
      ->Highpassfilter_CSTATE[0] += (q_srv02_pos_P.Highpassfilter_A[0])*
      q_srv02_pos_X.Highpassfilter_CSTATE[0]
      + (q_srv02_pos_P.Highpassfilter_A[1])*q_srv02_pos_X.Highpassfilter_CSTATE
      [1];
    ((StateDerivatives_q_srv02_pos *) q_srv02_pos_M->ModelData.derivs)
      ->Highpassfilter_CSTATE[1]= q_srv02_pos_X.Highpassfilter_CSTATE[0];
  }
}

/* Model initialize function */
void q_srv02_pos_initialize(boolean_T firstTime)
{
  (void)firstTime;

  /* Registration code */

  /* initialize non-finites */
  rt_InitInfAndNaN(sizeof(real_T));

  /* initialize real-time model */
  (void) memset((void *)q_srv02_pos_M, 0,
                sizeof(RT_MODEL_q_srv02_pos));

  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&q_srv02_pos_M->solverInfo,
                          &q_srv02_pos_M->Timing.simTimeStep);
    rtsiSetTPtr(&q_srv02_pos_M->solverInfo, &rtmGetTPtr(q_srv02_pos_M));
    rtsiSetStepSizePtr(&q_srv02_pos_M->solverInfo,
                       &q_srv02_pos_M->Timing.stepSize0);
    rtsiSetdXPtr(&q_srv02_pos_M->solverInfo, &q_srv02_pos_M->ModelData.derivs);
    rtsiSetContStatesPtr(&q_srv02_pos_M->solverInfo,
                         &q_srv02_pos_M->ModelData.contStates);
    rtsiSetNumContStatesPtr(&q_srv02_pos_M->solverInfo,
      &q_srv02_pos_M->Sizes.numContStates);
    rtsiSetErrorStatusPtr(&q_srv02_pos_M->solverInfo, (&rtmGetErrorStatus
      (q_srv02_pos_M)));
    rtsiSetRTModelPtr(&q_srv02_pos_M->solverInfo, q_srv02_pos_M);
  }

  rtsiSetSimTimeStep(&q_srv02_pos_M->solverInfo, MAJOR_TIME_STEP);
  q_srv02_pos_M->ModelData.intgData.f[0] = q_srv02_pos_M->ModelData.odeF[0];
  q_srv02_pos_M->ModelData.contStates = ((real_T *) &q_srv02_pos_X);
  rtsiSetSolverData(&q_srv02_pos_M->solverInfo, (void *)
                    &q_srv02_pos_M->ModelData.intgData);
  rtsiSetSolverName(&q_srv02_pos_M->solverInfo,"ode1");

  /* Initialize timing info */
  {
    int_T *mdlTsMap = q_srv02_pos_M->Timing.sampleTimeTaskIDArray;
    mdlTsMap[0] = 0;
    mdlTsMap[1] = 1;
    q_srv02_pos_M->Timing.sampleTimeTaskIDPtr = (&mdlTsMap[0]);
    q_srv02_pos_M->Timing.sampleTimes = (&q_srv02_pos_M->
      Timing.sampleTimesArray[0]);
    q_srv02_pos_M->Timing.offsetTimes = (&q_srv02_pos_M->
      Timing.offsetTimesArray[0]);

    /* task periods */
    q_srv02_pos_M->Timing.sampleTimes[0] = (0.0);
    q_srv02_pos_M->Timing.sampleTimes[1] = (0.002);

    /* task offsets */
    q_srv02_pos_M->Timing.offsetTimes[0] = (0.0);
    q_srv02_pos_M->Timing.offsetTimes[1] = (0.0);
  }

  rtmSetTPtr(q_srv02_pos_M, &q_srv02_pos_M->Timing.tArray[0]);

  {
    int_T *mdlSampleHits = q_srv02_pos_M->Timing.sampleHitArray;
    mdlSampleHits[0] = 1;
    mdlSampleHits[1] = 1;
    q_srv02_pos_M->Timing.sampleHits = (&mdlSampleHits[0]);
  }

  rtmSetTFinal(q_srv02_pos_M, -1);
  q_srv02_pos_M->Timing.stepSize0 = 0.002;
  q_srv02_pos_M->Timing.stepSize1 = 0.002;

  /* external mode info */
  q_srv02_pos_M->Sizes.checksums[0] = (1082214818U);
  q_srv02_pos_M->Sizes.checksums[1] = (2053776320U);
  q_srv02_pos_M->Sizes.checksums[2] = (3380358192U);
  q_srv02_pos_M->Sizes.checksums[3] = (3647969418U);

  {
    static const sysRanDType rtAlwaysEnabled = SUBSYS_RAN_BC_ENABLE;
    static RTWExtModeInfo rt_ExtModeInfo;
    static const sysRanDType *systemRan[5];
    q_srv02_pos_M->extModeInfo = (&rt_ExtModeInfo);
    rteiSetSubSystemActiveVectorAddresses(&rt_ExtModeInfo, systemRan);
    systemRan[0] = &rtAlwaysEnabled;
    systemRan[1] = &rtAlwaysEnabled;
    systemRan[2] = &rtAlwaysEnabled;
    systemRan[3] = &rtAlwaysEnabled;
    systemRan[4] = &rtAlwaysEnabled;
    rteiSetModelMappingInfoPtr(q_srv02_pos_M->extModeInfo,
      &q_srv02_pos_M->SpecialInfo.mappingInfo);
    rteiSetChecksumsPtr(q_srv02_pos_M->extModeInfo,
                        q_srv02_pos_M->Sizes.checksums);
    rteiSetTPtr(q_srv02_pos_M->extModeInfo, rtmGetTPtr(q_srv02_pos_M));
  }

  q_srv02_pos_M->solverInfoPtr = (&q_srv02_pos_M->solverInfo);
  q_srv02_pos_M->Timing.stepSize = (0.002);
  rtsiSetFixedStepSize(&q_srv02_pos_M->solverInfo, 0.002);
  rtsiSetSolverMode(&q_srv02_pos_M->solverInfo, SOLVER_MODE_SINGLETASKING);

  /* block I/O */
  q_srv02_pos_M->ModelData.blockIO = ((void *) &q_srv02_pos_B);
  (void) memset(((void *) &q_srv02_pos_B), 0,
                sizeof(BlockIO_q_srv02_pos));

  {
    q_srv02_pos_B.HILReadAnalogTimebase_o1 = 0.0;
    q_srv02_pos_B.HILReadAnalogTimebase_o2 = 0.0;
    q_srv02_pos_B.HILReadEncoder = 0.0;
    q_srv02_pos_B.EncoderCalibrationradcount = 0.0;
    q_srv02_pos_B.EncoderHighPassFilter = 0.0;
    q_srv02_pos_B.PositionSourceSwitch = 0.0;
    q_srv02_pos_B.TachometerCalibrationradsV = 0.0;
    q_srv02_pos_B.VelocitySourceSwitch = 0.0;
    q_srv02_pos_B.SquareWave = 0.0;
    q_srv02_pos_B.Clock = 0.0;
    q_srv02_pos_B.SineWave = 0.0;
    q_srv02_pos_B.MultiportSwitch = 0.0;
    q_srv02_pos_B.Amplituderad = 0.0;
    q_srv02_pos_B.PositionErrorrad = 0.0;
    q_srv02_pos_B.ProportionalGainVrad = 0.0;
    q_srv02_pos_B.Integrator = 0.0;
    q_srv02_pos_B.Highpassfilter = 0.0;
    q_srv02_pos_B.VelocityGainVsrad = 0.0;
    q_srv02_pos_B.ControlOutput = 0.0;
    q_srv02_pos_B.DirectionConventionRightHandsys = 0.0;
    q_srv02_pos_B.AmplifierSaturationV = 0.0;
    q_srv02_pos_B.InverseAmplifierGainVV = 0.0;
    q_srv02_pos_B.DACBSaturationV = 0.0;
    q_srv02_pos_B.AmplifierGainVV = 0.0;
    q_srv02_pos_B.theta_ldeg = 0.0;
    q_srv02_pos_B.IntegralGainVrads = 0.0;
    q_srv02_pos_B.PotentiometerCalibrationradV = 0.0;
    q_srv02_pos_B.t = 0.0;
    q_srv02_pos_B.MultiportSwitch_p = 0.0;
    q_srv02_pos_B.R0 = 0.0;
    q_srv02_pos_B.Sum = 0.0;
    q_srv02_pos_B.t12f = 0.0;
    q_srv02_pos_B.R0t12f = 0.0;
    q_srv02_pos_B.Sum1 = 0.0;
  }

  /* parameters */
  q_srv02_pos_M->ModelData.defaultParam = ((real_T *)&q_srv02_pos_P);

  /* states (continuous) */
  {
    real_T *x = (real_T *) &q_srv02_pos_X;
    q_srv02_pos_M->ModelData.contStates = (x);
    (void) memset((void *)&q_srv02_pos_X, 0,
                  sizeof(ContinuousStates_q_srv02_pos));
  }

  /* states (dwork) */
  q_srv02_pos_M->Work.dwork = ((void *) &q_srv02_pos_DWork);
  (void) memset((void *)&q_srv02_pos_DWork, 0,
                sizeof(D_Work_q_srv02_pos));

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_pos_DWork.HILInitialize_AIMinimums[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_pos_DWork.HILInitialize_AIMaximums[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_pos_DWork.HILInitialize_AOMinimums[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_pos_DWork.HILInitialize_AOMaximums[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_pos_DWork.HILInitialize_AOVoltages[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_pos_DWork.HILInitialize_FilterFrequency[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_pos_DWork.HILInitialize_POSortedFreqs[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_pos_DWork.HILInitialize_POValues[i] = 0.0;
    }
  }

  q_srv02_pos_DWork.HILReadAnalogTimebase_Buffer[0] = 0.0;
  q_srv02_pos_DWork.HILReadAnalogTimebase_Buffer[1] = 0.0;

  /* data type transition information */
  {
    static DataTypeTransInfo dtInfo;
    (void) memset((char_T *) &dtInfo, 0,
                  sizeof(dtInfo));
    q_srv02_pos_M->SpecialInfo.mappingInfo = (&dtInfo);
    dtInfo.numDataTypes = 16;
    dtInfo.dataTypeSizes = &rtDataTypeSizes[0];
    dtInfo.dataTypeNames = &rtDataTypeNames[0];

    /* Block I/O transition table */
    dtInfo.B = &rtBTransTable;

    /* Parameters transition table */
    dtInfo.P = &rtPTransTable;
  }
}

/* Model terminate function */
void q_srv02_pos_terminate(void)
{
  /* Terminate for S-Function (hil_initialize_block): '<S6>/HIL Initialize' */

  /* S-Function Block: q_srv02_pos/SRV02-ET Position/SRV02-ET/HIL Initialize (hil_initialize_block) */
  {
    t_boolean is_switching;
    t_int result;
    hil_task_stop_all(q_srv02_pos_DWork.HILInitialize_Card);
    hil_task_delete_all(q_srv02_pos_DWork.HILInitialize_Card);
    hil_monitor_stop_all(q_srv02_pos_DWork.HILInitialize_Card);
    hil_monitor_delete_all(q_srv02_pos_DWork.HILInitialize_Card);
    is_switching = reconfiguration_is_switching_out(_reconfiguration);
    if ((q_srv02_pos_P.HILInitialize_AOTerminate && !is_switching) ||
        (q_srv02_pos_P.HILInitialize_AOExit && is_switching)) {
      {
        int_T i1;
        real_T *dw_AOVoltages = &q_srv02_pos_DWork.HILInitialize_AOVoltages[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOVoltages[i1] = q_srv02_pos_P.HILInitialize_AOFinal;
        }
      }

      result = hil_write_analog(q_srv02_pos_DWork.HILInitialize_Card,
        &q_srv02_pos_P.HILInitialize_AOChannels[0], 8U,
        &q_srv02_pos_DWork.HILInitialize_AOVoltages[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
      }
    }

    if ((q_srv02_pos_P.HILInitialize_POTerminate && !is_switching) ||
        (q_srv02_pos_P.HILInitialize_POExit && is_switching)) {
      {
        int_T i1;
        real_T *dw_POValues = &q_srv02_pos_DWork.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = q_srv02_pos_P.HILInitialize_POFinal;
        }
      }

      result = hil_write_pwm(q_srv02_pos_DWork.HILInitialize_Card,
        &q_srv02_pos_P.HILInitialize_POChannels[0], 8U,
        &q_srv02_pos_DWork.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
      }
    }

    hil_close(q_srv02_pos_DWork.HILInitialize_Card);
    q_srv02_pos_DWork.HILInitialize_Card = NULL;
  }
}

/*========================================================================*
 * Start of GRT compatible call interface                                 *
 *========================================================================*/

/* Solver interface called by GRT_Main */
#ifndef USE_GENERATED_SOLVER

void rt_ODECreateIntegrationData(RTWSolverInfo *si)
{
  UNUSED_PARAMETER(si);
  return;
}                                      /* do nothing */

void rt_ODEDestroyIntegrationData(RTWSolverInfo *si)
{
  UNUSED_PARAMETER(si);
  return;
}                                      /* do nothing */

void rt_ODEUpdateContinuousStates(RTWSolverInfo *si)
{
  UNUSED_PARAMETER(si);
  return;
}                                      /* do nothing */

#endif

void MdlOutputs(int_T tid)
{
  q_srv02_pos_output(tid);
}

void MdlUpdate(int_T tid)
{
  q_srv02_pos_update(tid);
}

void MdlInitializeSizes(void)
{
  q_srv02_pos_M->Sizes.numContStates = (5);/* Number of continuous states */
  q_srv02_pos_M->Sizes.numY = (0);     /* Number of model outputs */
  q_srv02_pos_M->Sizes.numU = (0);     /* Number of model inputs */
  q_srv02_pos_M->Sizes.sysDirFeedThru = (0);/* The model is not direct feedthrough */
  q_srv02_pos_M->Sizes.numSampTimes = (2);/* Number of sample times */
  q_srv02_pos_M->Sizes.numBlocks = (48);/* Number of blocks */
  q_srv02_pos_M->Sizes.numBlockIO = (35);/* Number of block outputs */
  q_srv02_pos_M->Sizes.numBlockPrms = (139);/* Sum of parameter "widths" */
}

void MdlInitializeSampleTimes(void)
{
}

void MdlInitialize(void)
{
  /* InitializeConditions for TransferFcn: '<S6>/Encoder High-Pass Filter' */
  q_srv02_pos_X.EncoderHighPassFilter_CSTATE[0] = 0.0;
  q_srv02_pos_X.EncoderHighPassFilter_CSTATE[1] = 0.0;

  /* InitializeConditions for Integrator: '<S1>/Integrator' */
  q_srv02_pos_X.Integrator_CSTATE = q_srv02_pos_P.Integrator_IC;

  /* InitializeConditions for TransferFcn: '<S1>/High-pass filter' */
  q_srv02_pos_X.Highpassfilter_CSTATE[0] = 0.0;
  q_srv02_pos_X.Highpassfilter_CSTATE[1] = 0.0;
}

void MdlStart(void)
{
  /* Start for S-Function (hil_initialize_block): '<S6>/HIL Initialize' */

  /* S-Function Block: q_srv02_pos/SRV02-ET Position/SRV02-ET/HIL Initialize (hil_initialize_block) */
  {
    t_int result;
    t_boolean is_switching;
    result = hil_open("q8_usb", "0", &q_srv02_pos_DWork.HILInitialize_Card);
    if (result < 0) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
      return;
    }

    is_switching = reconfiguration_is_switching_in(_reconfiguration);
    result = hil_set_card_specific_options(q_srv02_pos_DWork.HILInitialize_Card,
      "update_rate=normal", 19);
    if (result < 0) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
      return;
    }

    result = hil_watchdog_clear(q_srv02_pos_DWork.HILInitialize_Card);
    if (result < 0 && result != -QERR_HIL_WATCHDOG_CLEAR) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
      return;
    }

    if ((q_srv02_pos_P.HILInitialize_AIPStart && !is_switching) ||
        (q_srv02_pos_P.HILInitialize_AIPEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_AIMinimums = &q_srv02_pos_DWork.HILInitialize_AIMinimums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AIMinimums[i1] = q_srv02_pos_P.HILInitialize_AILow;
        }
      }

      {
        int_T i1;
        real_T *dw_AIMaximums = &q_srv02_pos_DWork.HILInitialize_AIMaximums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AIMaximums[i1] = q_srv02_pos_P.HILInitialize_AIHigh;
        }
      }

      result = hil_set_analog_input_ranges(q_srv02_pos_DWork.HILInitialize_Card,
        &q_srv02_pos_P.HILInitialize_AIChannels[0], 8U,
        &q_srv02_pos_DWork.HILInitialize_AIMinimums[0],
        &q_srv02_pos_DWork.HILInitialize_AIMaximums[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
        return;
      }
    }

    if ((q_srv02_pos_P.HILInitialize_AOPStart && !is_switching) ||
        (q_srv02_pos_P.HILInitialize_AOPEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_AOMinimums = &q_srv02_pos_DWork.HILInitialize_AOMinimums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOMinimums[i1] = q_srv02_pos_P.HILInitialize_AOLow;
        }
      }

      {
        int_T i1;
        real_T *dw_AOMaximums = &q_srv02_pos_DWork.HILInitialize_AOMaximums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOMaximums[i1] = q_srv02_pos_P.HILInitialize_AOHigh;
        }
      }

      result = hil_set_analog_output_ranges(q_srv02_pos_DWork.HILInitialize_Card,
        &q_srv02_pos_P.HILInitialize_AOChannels[0], 8U,
        &q_srv02_pos_DWork.HILInitialize_AOMinimums[0],
        &q_srv02_pos_DWork.HILInitialize_AOMaximums[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
        return;
      }
    }

    if ((q_srv02_pos_P.HILInitialize_AOStart && !is_switching) ||
        (q_srv02_pos_P.HILInitialize_AOEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_AOVoltages = &q_srv02_pos_DWork.HILInitialize_AOVoltages[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOVoltages[i1] = q_srv02_pos_P.HILInitialize_AOInitial;
        }
      }

      result = hil_write_analog(q_srv02_pos_DWork.HILInitialize_Card,
        &q_srv02_pos_P.HILInitialize_AOChannels[0], 8U,
        &q_srv02_pos_DWork.HILInitialize_AOVoltages[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
        return;
      }
    }

    if (q_srv02_pos_P.HILInitialize_AOReset) {
      {
        int_T i1;
        real_T *dw_AOVoltages = &q_srv02_pos_DWork.HILInitialize_AOVoltages[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOVoltages[i1] = q_srv02_pos_P.HILInitialize_AOWatchdog;
        }
      }

      result = hil_watchdog_set_analog_expiration_state
        (q_srv02_pos_DWork.HILInitialize_Card,
         &q_srv02_pos_P.HILInitialize_AOChannels[0], 8U,
         &q_srv02_pos_DWork.HILInitialize_AOVoltages[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
        return;
      }
    }

    if ((q_srv02_pos_P.HILInitialize_EIPStart && !is_switching) ||
        (q_srv02_pos_P.HILInitialize_EIPEnter && is_switching)) {
      {
        int_T i1;
        int32_T *dw_QuadratureModes =
          &q_srv02_pos_DWork.HILInitialize_QuadratureModes[0];
        for (i1=0; i1 < 8; i1++) {
          dw_QuadratureModes[i1] = q_srv02_pos_P.HILInitialize_EIQuadrature;
        }
      }

      result = hil_set_encoder_quadrature_mode
        (q_srv02_pos_DWork.HILInitialize_Card,
         &q_srv02_pos_P.HILInitialize_EIChannels[0], 8U,
         (t_encoder_quadrature_mode *)
         &q_srv02_pos_DWork.HILInitialize_QuadratureModes[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
        return;
      }
    }

    if ((q_srv02_pos_P.HILInitialize_EIStart && !is_switching) ||
        (q_srv02_pos_P.HILInitialize_EIEnter && is_switching)) {
      {
        int_T i1;
        int32_T *dw_InitialEICounts =
          &q_srv02_pos_DWork.HILInitialize_InitialEICounts[0];
        for (i1=0; i1 < 8; i1++) {
          dw_InitialEICounts[i1] = q_srv02_pos_P.HILInitialize_EIInitial;
        }
      }

      result = hil_set_encoder_counts(q_srv02_pos_DWork.HILInitialize_Card,
        &q_srv02_pos_P.HILInitialize_EIChannels[0], 8U,
        &q_srv02_pos_DWork.HILInitialize_InitialEICounts[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
        return;
      }
    }

    if ((q_srv02_pos_P.HILInitialize_POPStart && !is_switching) ||
        (q_srv02_pos_P.HILInitialize_POPEnter && is_switching)) {
      uint32_T num_duty_cycle_modes = 0;
      uint32_T num_frequency_modes = 0;

      {
        int_T i1;
        int32_T *dw_POModeValues =
          &q_srv02_pos_DWork.HILInitialize_POModeValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POModeValues[i1] = q_srv02_pos_P.HILInitialize_POModes;
        }
      }

      result = hil_set_pwm_mode(q_srv02_pos_DWork.HILInitialize_Card,
        &q_srv02_pos_P.HILInitialize_POChannels[0], 8U, (t_pwm_mode *)
        &q_srv02_pos_DWork.HILInitialize_POModeValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
        return;
      }

      {
        int_T i1;
        const uint32_T *p_HILInitialize_POChannels =
          &q_srv02_pos_P.HILInitialize_POChannels[0];
        int32_T *dw_POModeValues =
          &q_srv02_pos_DWork.HILInitialize_POModeValues[0];
        for (i1=0; i1 < 8; i1++) {
          if (dw_POModeValues[i1] == PWM_DUTY_CYCLE_MODE || dw_POModeValues[i1] ==
              PWM_ONE_SHOT_MODE || dw_POModeValues[i1] == PWM_TIME_MODE) {
            q_srv02_pos_DWork.HILInitialize_POSortedChans[num_duty_cycle_modes] =
              (p_HILInitialize_POChannels[i1]);
            q_srv02_pos_DWork.HILInitialize_POSortedFreqs[num_duty_cycle_modes] =
              q_srv02_pos_P.HILInitialize_POFrequency;
            num_duty_cycle_modes++;
          } else {
            q_srv02_pos_DWork.HILInitialize_POSortedChans[7U -
              num_frequency_modes] = (p_HILInitialize_POChannels[i1]);
            q_srv02_pos_DWork.HILInitialize_POSortedFreqs[7U -
              num_frequency_modes] = q_srv02_pos_P.HILInitialize_POFrequency;
            num_frequency_modes++;
          }
        }
      }

      if (num_duty_cycle_modes > 0) {
        result = hil_set_pwm_frequency(q_srv02_pos_DWork.HILInitialize_Card,
          &q_srv02_pos_DWork.HILInitialize_POSortedChans[0],
          num_duty_cycle_modes, &q_srv02_pos_DWork.HILInitialize_POSortedFreqs[0]);
        if (result < 0) {
          msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
            (_rt_error_message));
          rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
          return;
        }
      }

      if (num_frequency_modes > 0) {
        result = hil_set_pwm_duty_cycle(q_srv02_pos_DWork.HILInitialize_Card,
          &q_srv02_pos_DWork.HILInitialize_POSortedChans[num_duty_cycle_modes],
          num_frequency_modes,
          &q_srv02_pos_DWork.HILInitialize_POSortedFreqs[num_duty_cycle_modes]);
        if (result < 0) {
          msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
            (_rt_error_message));
          rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
          return;
        }
      }

      {
        int_T i1;
        int32_T *dw_POModeValues =
          &q_srv02_pos_DWork.HILInitialize_POModeValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POModeValues[i1] = q_srv02_pos_P.HILInitialize_POConfiguration;
        }
      }

      {
        int_T i1;
        int32_T *dw_POAlignValues =
          &q_srv02_pos_DWork.HILInitialize_POAlignValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POAlignValues[i1] = q_srv02_pos_P.HILInitialize_POAlignment;
        }
      }

      {
        int_T i1;
        int32_T *dw_POPolarityVals =
          &q_srv02_pos_DWork.HILInitialize_POPolarityVals[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POPolarityVals[i1] = q_srv02_pos_P.HILInitialize_POPolarity;
        }
      }

      result = hil_set_pwm_configuration(q_srv02_pos_DWork.HILInitialize_Card,
        &q_srv02_pos_P.HILInitialize_POChannels[0], 8U,
        (t_pwm_configuration *) &q_srv02_pos_DWork.HILInitialize_POModeValues[0],
        (t_pwm_alignment *) &q_srv02_pos_DWork.HILInitialize_POAlignValues[0],
        (t_pwm_polarity *) &q_srv02_pos_DWork.HILInitialize_POPolarityVals[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
        return;
      }

      {
        int_T i1;
        real_T *dw_POSortedFreqs =
          &q_srv02_pos_DWork.HILInitialize_POSortedFreqs[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POSortedFreqs[i1] = q_srv02_pos_P.HILInitialize_POLeading;
        }
      }

      {
        int_T i1;
        real_T *dw_POValues = &q_srv02_pos_DWork.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = q_srv02_pos_P.HILInitialize_POTrailing;
        }
      }

      result = hil_set_pwm_deadband(q_srv02_pos_DWork.HILInitialize_Card,
        &q_srv02_pos_P.HILInitialize_POChannels[0], 8U,
        &q_srv02_pos_DWork.HILInitialize_POSortedFreqs[0],
        &q_srv02_pos_DWork.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
        return;
      }
    }

    if ((q_srv02_pos_P.HILInitialize_POStart && !is_switching) ||
        (q_srv02_pos_P.HILInitialize_POEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_POValues = &q_srv02_pos_DWork.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = q_srv02_pos_P.HILInitialize_POInitial;
        }
      }

      result = hil_write_pwm(q_srv02_pos_DWork.HILInitialize_Card,
        &q_srv02_pos_P.HILInitialize_POChannels[0], 8U,
        &q_srv02_pos_DWork.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
        return;
      }
    }

    if (q_srv02_pos_P.HILInitialize_POReset) {
      {
        int_T i1;
        real_T *dw_POValues = &q_srv02_pos_DWork.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = q_srv02_pos_P.HILInitialize_POWatchdog;
        }
      }

      result = hil_watchdog_set_pwm_expiration_state
        (q_srv02_pos_DWork.HILInitialize_Card,
         &q_srv02_pos_P.HILInitialize_POChannels[0], 8U,
         &q_srv02_pos_DWork.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
        return;
      }
    }
  }

  /* Start for S-Function (hil_read_analog_timebase_block): '<S6>/HIL Read Analog Timebase' */

  /* S-Function Block: q_srv02_pos/SRV02-ET Position/SRV02-ET/HIL Read Analog Timebase (hil_read_analog_timebase_block) */
  {
    t_error result;
    result = hil_task_create_analog_reader(q_srv02_pos_DWork.HILInitialize_Card,
      q_srv02_pos_P.HILReadAnalogTimebase_SamplesIn,
      q_srv02_pos_P.HILReadAnalogTimebase_Channels, 2,
      &q_srv02_pos_DWork.HILReadAnalogTimebase_Task);
    if (result < 0) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(q_srv02_pos_M, _rt_error_message);
    }
  }

  MdlInitialize();
}

void MdlTerminate(void)
{
  q_srv02_pos_terminate();
}

RT_MODEL_q_srv02_pos *q_srv02_pos(void)
{
  q_srv02_pos_initialize(1);
  return q_srv02_pos_M;
}

/*========================================================================*
 * End of GRT compatible call interface                                   *
 *========================================================================*/
